#ifdef SKINNING

uniform mat4 	boneMatrices[100],
		prevBoneMatrices[100];
//attribute vec4  weights;
//attribute vec4  matrixIndices;

#endif

varying vec2 	texcoord;
uniform vec2	tscale0;

//attribute vec3 	normal;
attribute vec4	binormal; 

vec4 		outNormal,
		outTangent,
		outBinormal; 

varying vec3	eye0,
		eye1,
		eye2;

uniform mat4	prevMVM,
		WTM;
varying vec4 	pos,
		prev;

void main()
{

	texcoord = gl_MultiTexCoord0.st*tscale0;

	vec4 normal4      	= vec4( gl_Normal.xyz, 0.0 );
	vec4 binormal4      = vec4( binormal.xyz, 0.0 );
	vec4 tangent4      	= vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=binormal.w;
  
#ifdef SKINNING


	vec4 index  = gl_SecondaryColor;//matrixIndices;
	vec4 weight = gl_Color;//weights;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempNormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempTangent  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempBinormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 prevpos 		= vec4( 0.0, 0.0, 0.0, 0.0 );

	mat4 TM;

  	for( int i = 0; i < 4; i++ )
 	{
 	    	// Apply influence of bone i
		TM=boneMatrices[int(index[i])];
  	    	position = position + (TM * gl_Vertex) *weight[i];
		
		// Transform normals by bone i
		TM[3]=vec4(0,0,0,1);
  	    	tempNormal = tempNormal + (TM * normal4)*weight[i];
		tempBinormal = tempBinormal + (TM * binormal4)*weight[i];
		tempTangent = tempTangent + (TM * tangent4)*weight[i];
	}
	gl_Position = gl_ModelViewProjectionMatrix * position;	
	
	normal4=tempNormal;
	tangent4=tempTangent;
	binormal4=tempBinormal;
	
	prevpos = prevpos + ((prevBoneMatrices[int(index.x)] * gl_Vertex) * weight.x);
	prevpos = prevpos + ((prevBoneMatrices[int(index.y)] * gl_Vertex) * weight.y);
	prevpos = prevpos + ((prevBoneMatrices[int(index.z)] * gl_Vertex) * weight.z);
	prevpos = prevpos + ((prevBoneMatrices[int(index.w)] * gl_Vertex) * weight.w);
	prev = gl_ProjectionMatrix*prevMVM*prevpos;

#else

	gl_Position = ftransform();
	mat4 MVP=gl_ProjectionMatrix*prevMVM*WTM;
	prev=MVP*gl_Vertex;

#endif

	outNormal=gl_ModelViewMatrix*normal4;
	outTangent=gl_ModelViewMatrix*tangent4;
	outBinormal=gl_ModelViewMatrix*binormal4; 

	normalize(outNormal);
	normalize(outTangent);
	normalize(outBinormal);

	eye0=vec3(outTangent.x,outBinormal.x,outNormal.x);
	eye1=vec3(outTangent.y,outBinormal.y,outNormal.y);
	eye2=vec3(outTangent.z,outBinormal.z,outNormal.z);
	
	pos=gl_Position;
}